<?php
/**
* @package XenCentral Ad Server
* @author Skydevelop EU
* @copyright Drnoyan & Nalyan LDA, Portugal, EU
* @license http://www.dnf.pt/eula.html
* @link http://www.skydevelop.com
* @revision 97
* @version 2.0.0 beta 3 rev. 3
*/

	
class XenCentral_AdServer_TagHandler_Banner extends XenForo_TagHandler_Abstract
{
    protected $_bannerModel;
    
    public function getPermissionsFromContext(array $context, array $parentContext = null)
    {
        return array(
            'edit' => true,
            'removeOthers' => false,
            'minTotal' => 0
        );
    }

    public function getBasicContent($id)
    {
        return $this->_getBannerModel()->getBannerById($id);
    }

    public function getContentDate(array $content)
    {
        return 0;
    }

    public function getContentVisibility(array $content)
    {
        return $content['status']!='moderated';
    }

    public function updateContentTagCache(array $content, array $cache)
    {
        $dw = XenForo_DataWriter::create('XenCentral_AdServer_DataWriter_Banner');
        $dw->setExistingData($content['bannerId']);
        $dw->set('tags', $cache);
        $dw->save();
    }

    public function getDataForResults(array $ids, array $viewingUser, array $resultsGrouped)
    {
        // not used to display in tag clouds
        return array();
    }

    public function canViewResult(array $result, array $viewingUser)
    {
        return false;
    }

    public function prepareResult(array $result, array $viewingUser)
    {
        return $result;
    }

    public function renderResult(XenForo_View $view, array $result)
    {
        return false;
    }

    /**
     * @return XenCentral_AdServer_Model_Banner
     * @throws XenForo_Exception
     */
    protected function _getBannerModel()
    {
        if (!$this->_bannerModel) {
            $this->_bannerModel = XenForo_Model::create('XenCentral_AdServer_Model_Banner');
        }

        return $this->_bannerModel;
    }
}